import base64
import struct
import json
import zlib

def decode_flask_cookie(cookie):
    parts = cookie.split('.')
    if len(parts) != 3:
        print(f"Cookie has {len(parts)} parts instead of 3")
        return

    payload_b64, timestamp_b64, signature_b64 = parts
    try:
        # Add padding if necessary
        payload_b64 += '=' * (-len(payload_b64) % 4)
        payload_bytes = base64.urlsafe_b64decode(payload_b64)
        
        if payload_bytes.startswith(b'.'):
            payload = zlib.decompress(payload_bytes[1:])
        else:
            payload = payload_bytes
        
        print(f"Payload: {payload.decode('utf-8')}")
    except Exception as e:
        print(f"Error decoding payload: {e}")

    try:
        timestamp_b64 += '=' * (-len(timestamp_b64) % 4)
        timestamp_bytes = base64.urlsafe_b64decode(timestamp_b64)
        if len(timestamp_bytes) == 4:
            timestamp = struct.unpack(">I", timestamp_bytes)[0]
            print(f"Timestamp: {timestamp}")
            import datetime
            print(f"Date: {datetime.datetime.fromtimestamp(timestamp, datetime.timezone.utc)}")
        else:
            print(f"Timestamp bytes length: {len(timestamp_bytes)}")
    except Exception as e:
        print(f"Error decoding timestamp: {e}")

    try:
        signature_b64 += '=' * (-len(signature_b64) % 4)
        signature_bytes = base64.urlsafe_b64decode(signature_b64)
        print(f"Signature length: {len(signature_bytes)} bytes")
        print(f"Signature hex: {signature_bytes.hex()}")
    except Exception as e:
        print(f"Error decoding signature: {e}")

if __name__ == "__main__":
    cookie = input("Enter the Flask session cookie to decode: ")
    decode_flask_cookie(cookie)
